<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vault;

class TeamDriveInfo extends \Google\Collection
{
  protected $collection_key = 'teamDriveIds';
  /**
   * List of Team Drive IDs, as provided by the [Drive
   * API](https://developers.google.com/drive).
   *
   * @deprecated
   * @var string[]
   */
  public $teamDriveIds;

  /**
   * List of Team Drive IDs, as provided by the [Drive
   * API](https://developers.google.com/drive).
   *
   * @deprecated
   * @param string[] $teamDriveIds
   */
  public function setTeamDriveIds($teamDriveIds)
  {
    $this->teamDriveIds = $teamDriveIds;
  }
  /**
   * @deprecated
   * @return string[]
   */
  public function getTeamDriveIds()
  {
    return $this->teamDriveIds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TeamDriveInfo::class, 'Google_Service_Vault_TeamDriveInfo');
