<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class VulnerabilitySnapshot extends \Google\Model
{
  /**
   * The cloud provider is unspecified.
   */
  public const CLOUD_PROVIDER_CLOUD_PROVIDER_UNSPECIFIED = 'CLOUD_PROVIDER_UNSPECIFIED';
  /**
   * The cloud provider is Google Cloud.
   */
  public const CLOUD_PROVIDER_GOOGLE_CLOUD_PLATFORM = 'GOOGLE_CLOUD_PLATFORM';
  /**
   * The cloud provider is Amazon Web Services.
   */
  public const CLOUD_PROVIDER_AMAZON_WEB_SERVICES = 'AMAZON_WEB_SERVICES';
  /**
   * The cloud provider is Microsoft Azure.
   */
  public const CLOUD_PROVIDER_MICROSOFT_AZURE = 'MICROSOFT_AZURE';
  /**
   * The cloud provider for the vulnerability snapshot.
   *
   * @var string
   */
  public $cloudProvider;
  protected $findingCountType = VulnerabilityCountBySeverity::class;
  protected $findingCountDataType = '';
  /**
   * Identifier. The vulnerability snapshot name. Format:
   * //locations//vulnerabilitySnapshots/
   *
   * @var string
   */
  public $name;
  /**
   * The time that the snapshot was taken.
   *
   * @var string
   */
  public $snapshotTime;

  /**
   * The cloud provider for the vulnerability snapshot.
   *
   * Accepted values: CLOUD_PROVIDER_UNSPECIFIED, GOOGLE_CLOUD_PLATFORM,
   * AMAZON_WEB_SERVICES, MICROSOFT_AZURE
   *
   * @param self::CLOUD_PROVIDER_* $cloudProvider
   */
  public function setCloudProvider($cloudProvider)
  {
    $this->cloudProvider = $cloudProvider;
  }
  /**
   * @return self::CLOUD_PROVIDER_*
   */
  public function getCloudProvider()
  {
    return $this->cloudProvider;
  }
  /**
   * The vulnerability count by severity.
   *
   * @param VulnerabilityCountBySeverity $findingCount
   */
  public function setFindingCount(VulnerabilityCountBySeverity $findingCount)
  {
    $this->findingCount = $findingCount;
  }
  /**
   * @return VulnerabilityCountBySeverity
   */
  public function getFindingCount()
  {
    return $this->findingCount;
  }
  /**
   * Identifier. The vulnerability snapshot name. Format:
   * //locations//vulnerabilitySnapshots/
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The time that the snapshot was taken.
   *
   * @param string $snapshotTime
   */
  public function setSnapshotTime($snapshotTime)
  {
    $this->snapshotTime = $snapshotTime;
  }
  /**
   * @return string
   */
  public function getSnapshotTime()
  {
    return $this->snapshotTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilitySnapshot::class, 'Google_Service_SecurityCommandCenter_VulnerabilitySnapshot');
