<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\RecommendationsAI;

class GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRange extends \Google\Model
{
  /**
   * Required. The maximum product price.
   *
   * @var float
   */
  public $max;
  /**
   * Required. The minimum product price.
   *
   * @var float
   */
  public $min;

  /**
   * Required. The maximum product price.
   *
   * @param float $max
   */
  public function setMax($max)
  {
    $this->max = $max;
  }
  /**
   * @return float
   */
  public function getMax()
  {
    return $this->max;
  }
  /**
   * Required. The minimum product price.
   *
   * @param float $min
   */
  public function setMin($min)
  {
    $this->min = $min;
  }
  /**
   * @return float
   */
  public function getMin()
  {
    return $this->min;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRange::class, 'Google_Service_RecommendationsAI_GoogleCloudRecommendationengineV1beta1ProductCatalogItemPriceRange');
