<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\RecaptchaEnterprise;

class GoogleCloudRecaptchaenterpriseV1ScoreDistribution extends \Google\Model
{
  /**
   * Map key is score value multiplied by 100. The scores are discrete values
   * between [0, 1]. The maximum number of buckets is on order of a few dozen,
   * but typically much lower (ie. 10).
   *
   * @var string[]
   */
  public $scoreBuckets;

  /**
   * Map key is score value multiplied by 100. The scores are discrete values
   * between [0, 1]. The maximum number of buckets is on order of a few dozen,
   * but typically much lower (ie. 10).
   *
   * @param string[] $scoreBuckets
   */
  public function setScoreBuckets($scoreBuckets)
  {
    $this->scoreBuckets = $scoreBuckets;
  }
  /**
   * @return string[]
   */
  public function getScoreBuckets()
  {
    return $this->scoreBuckets;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRecaptchaenterpriseV1ScoreDistribution::class, 'Google_Service_RecaptchaEnterprise_GoogleCloudRecaptchaenterpriseV1ScoreDistribution');
