<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class ServiceLevelIndicator extends \Google\Model
{
  protected $basicSliType = BasicSli::class;
  protected $basicSliDataType = '';
  protected $requestBasedType = RequestBasedSli::class;
  protected $requestBasedDataType = '';
  protected $windowsBasedType = WindowsBasedSli::class;
  protected $windowsBasedDataType = '';

  /**
   * Basic SLI on a well-known service type.
   *
   * @param BasicSli $basicSli
   */
  public function setBasicSli(BasicSli $basicSli)
  {
    $this->basicSli = $basicSli;
  }
  /**
   * @return BasicSli
   */
  public function getBasicSli()
  {
    return $this->basicSli;
  }
  /**
   * Request-based SLIs
   *
   * @param RequestBasedSli $requestBased
   */
  public function setRequestBased(RequestBasedSli $requestBased)
  {
    $this->requestBased = $requestBased;
  }
  /**
   * @return RequestBasedSli
   */
  public function getRequestBased()
  {
    return $this->requestBased;
  }
  /**
   * Windows-based SLIs
   *
   * @param WindowsBasedSli $windowsBased
   */
  public function setWindowsBased(WindowsBasedSli $windowsBased)
  {
    $this->windowsBased = $windowsBased;
  }
  /**
   * @return WindowsBasedSli
   */
  public function getWindowsBased()
  {
    return $this->windowsBased;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ServiceLevelIndicator::class, 'Google_Service_Monitoring_ServiceLevelIndicator');
