<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dns;

class ManagedZonePrivateVisibilityConfigGKECluster extends \Google\Model
{
  /**
   * The resource name of the cluster to bind this ManagedZone to. This should
   * be specified in the format like: projects/locations/clusters. This is
   * referenced from GKE projects.locations.clusters.get API:
   * https://cloud.google.com/kubernetes-
   * engine/docs/reference/rest/v1/projects.locations.clusters/get
   *
   * @var string
   */
  public $gkeClusterName;
  /**
   * @var string
   */
  public $kind;

  /**
   * The resource name of the cluster to bind this ManagedZone to. This should
   * be specified in the format like: projects/locations/clusters. This is
   * referenced from GKE projects.locations.clusters.get API:
   * https://cloud.google.com/kubernetes-
   * engine/docs/reference/rest/v1/projects.locations.clusters/get
   *
   * @param string $gkeClusterName
   */
  public function setGkeClusterName($gkeClusterName)
  {
    $this->gkeClusterName = $gkeClusterName;
  }
  /**
   * @return string
   */
  public function getGkeClusterName()
  {
    return $this->gkeClusterName;
  }
  /**
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ManagedZonePrivateVisibilityConfigGKECluster::class, 'Google_Service_Dns_ManagedZonePrivateVisibilityConfigGKECluster');
