<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudResourceManager;

class SearchFoldersResponse extends \Google\Collection
{
  protected $collection_key = 'folders';
  protected $foldersType = Folder::class;
  protected $foldersDataType = 'array';
  /**
   * A pagination token returned from a previous call to `SearchFolders` that
   * indicates from where searching should continue.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * A possibly paginated folder search results. the specified parent resource.
   *
   * @param Folder[] $folders
   */
  public function setFolders($folders)
  {
    $this->folders = $folders;
  }
  /**
   * @return Folder[]
   */
  public function getFolders()
  {
    return $this->folders;
  }
  /**
   * A pagination token returned from a previous call to `SearchFolders` that
   * indicates from where searching should continue.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SearchFoldersResponse::class, 'Google_Service_CloudResourceManager_SearchFoldersResponse');
