<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudAsset;

class GoogleCloudAssetV1AccessControlList extends \Google\Collection
{
  protected $collection_key = 'resources';
  protected $accessesType = GoogleCloudAssetV1Access::class;
  protected $accessesDataType = 'array';
  protected $conditionEvaluationType = ConditionEvaluation::class;
  protected $conditionEvaluationDataType = '';
  protected $resourceEdgesType = GoogleCloudAssetV1Edge::class;
  protected $resourceEdgesDataType = 'array';
  protected $resourcesType = GoogleCloudAssetV1Resource::class;
  protected $resourcesDataType = 'array';

  /**
   * The accesses that match one of the following conditions: - The
   * access_selector, if it is specified in request; - Otherwise, access
   * specifiers reachable from the policy binding's role.
   *
   * @param GoogleCloudAssetV1Access[] $accesses
   */
  public function setAccesses($accesses)
  {
    $this->accesses = $accesses;
  }
  /**
   * @return GoogleCloudAssetV1Access[]
   */
  public function getAccesses()
  {
    return $this->accesses;
  }
  /**
   * Condition evaluation for this AccessControlList, if there is a condition
   * defined in the above IAM policy binding.
   *
   * @param ConditionEvaluation $conditionEvaluation
   */
  public function setConditionEvaluation(ConditionEvaluation $conditionEvaluation)
  {
    $this->conditionEvaluation = $conditionEvaluation;
  }
  /**
   * @return ConditionEvaluation
   */
  public function getConditionEvaluation()
  {
    return $this->conditionEvaluation;
  }
  /**
   * Resource edges of the graph starting from the policy attached resource to
   * any descendant resources. The Edge.source_node contains the full resource
   * name of a parent resource and Edge.target_node contains the full resource
   * name of a child resource. This field is present only if the
   * output_resource_edges option is enabled in request.
   *
   * @param GoogleCloudAssetV1Edge[] $resourceEdges
   */
  public function setResourceEdges($resourceEdges)
  {
    $this->resourceEdges = $resourceEdges;
  }
  /**
   * @return GoogleCloudAssetV1Edge[]
   */
  public function getResourceEdges()
  {
    return $this->resourceEdges;
  }
  /**
   * The resources that match one of the following conditions: - The
   * resource_selector, if it is specified in request; - Otherwise, resources
   * reachable from the policy attached resource.
   *
   * @param GoogleCloudAssetV1Resource[] $resources
   */
  public function setResources($resources)
  {
    $this->resources = $resources;
  }
  /**
   * @return GoogleCloudAssetV1Resource[]
   */
  public function getResources()
  {
    return $this->resources;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAssetV1AccessControlList::class, 'Google_Service_CloudAsset_GoogleCloudAssetV1AccessControlList');
