<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Blogger;

class Comment extends \Google\Model
{
  public const STATUS_LIVE = 'LIVE';
  public const STATUS_EMPTIED = 'EMPTIED';
  public const STATUS_PENDING = 'PENDING';
  public const STATUS_SPAM = 'SPAM';
  protected $authorType = CommentAuthor::class;
  protected $authorDataType = '';
  protected $blogType = CommentBlog::class;
  protected $blogDataType = '';
  /**
   * The actual content of the comment. May include HTML markup.
   *
   * @var string
   */
  public $content;
  /**
   * The identifier for this resource.
   *
   * @var string
   */
  public $id;
  protected $inReplyToType = CommentInReplyTo::class;
  protected $inReplyToDataType = '';
  /**
   * The kind of this entry. Always blogger#comment.
   *
   * @var string
   */
  public $kind;
  protected $postType = CommentPost::class;
  protected $postDataType = '';
  /**
   * RFC 3339 date-time when this comment was published.
   *
   * @var string
   */
  public $published;
  /**
   * The API REST URL to fetch this resource from.
   *
   * @var string
   */
  public $selfLink;
  /**
   * The status of the comment (only populated for admin users).
   *
   * @var string
   */
  public $status;
  /**
   * RFC 3339 date-time when this comment was last updated.
   *
   * @var string
   */
  public $updated;

  /**
   * The author of this Comment.
   *
   * @param CommentAuthor $author
   */
  public function setAuthor(CommentAuthor $author)
  {
    $this->author = $author;
  }
  /**
   * @return CommentAuthor
   */
  public function getAuthor()
  {
    return $this->author;
  }
  /**
   * Data about the blog containing this comment.
   *
   * @param CommentBlog $blog
   */
  public function setBlog(CommentBlog $blog)
  {
    $this->blog = $blog;
  }
  /**
   * @return CommentBlog
   */
  public function getBlog()
  {
    return $this->blog;
  }
  /**
   * The actual content of the comment. May include HTML markup.
   *
   * @param string $content
   */
  public function setContent($content)
  {
    $this->content = $content;
  }
  /**
   * @return string
   */
  public function getContent()
  {
    return $this->content;
  }
  /**
   * The identifier for this resource.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Data about the comment this is in reply to.
   *
   * @param CommentInReplyTo $inReplyTo
   */
  public function setInReplyTo(CommentInReplyTo $inReplyTo)
  {
    $this->inReplyTo = $inReplyTo;
  }
  /**
   * @return CommentInReplyTo
   */
  public function getInReplyTo()
  {
    return $this->inReplyTo;
  }
  /**
   * The kind of this entry. Always blogger#comment.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Data about the post containing this comment.
   *
   * @param CommentPost $post
   */
  public function setPost(CommentPost $post)
  {
    $this->post = $post;
  }
  /**
   * @return CommentPost
   */
  public function getPost()
  {
    return $this->post;
  }
  /**
   * RFC 3339 date-time when this comment was published.
   *
   * @param string $published
   */
  public function setPublished($published)
  {
    $this->published = $published;
  }
  /**
   * @return string
   */
  public function getPublished()
  {
    return $this->published;
  }
  /**
   * The API REST URL to fetch this resource from.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * The status of the comment (only populated for admin users).
   *
   * Accepted values: LIVE, EMPTIED, PENDING, SPAM
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * RFC 3339 date-time when this comment was last updated.
   *
   * @param string $updated
   */
  public function setUpdated($updated)
  {
    $this->updated = $updated;
  }
  /**
   * @return string
   */
  public function getUpdated()
  {
    return $this->updated;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Comment::class, 'Google_Service_Blogger_Comment');
