<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BeyondCorp;

class GoogleCloudBeyondcorpAppconnectionsV1AppConnection extends \Google\Collection
{
  /**
   * Default value. This value is unused.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * AppConnection is being created.
   */
  public const STATE_CREATING = 'CREATING';
  /**
   * AppConnection has been created.
   */
  public const STATE_CREATED = 'CREATED';
  /**
   * AppConnection's configuration is being updated.
   */
  public const STATE_UPDATING = 'UPDATING';
  /**
   * AppConnection is being deleted.
   */
  public const STATE_DELETING = 'DELETING';
  /**
   * AppConnection is down and may be restored in the future. This happens when
   * CCFE sends ProjectState = OFF.
   */
  public const STATE_DOWN = 'DOWN';
  /**
   * Default value. This value is unused.
   */
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * TCP Proxy based BeyondCorp AppConnection. API will default to this if
   * unset.
   */
  public const TYPE_TCP_PROXY = 'TCP_PROXY';
  protected $collection_key = 'connectors';
  protected $applicationEndpointType = GoogleCloudBeyondcorpAppconnectionsV1AppConnectionApplicationEndpoint::class;
  protected $applicationEndpointDataType = '';
  /**
   * Optional. List of [google.cloud.beyondcorp.v1main.Connector.name] that are
   * authorised to be associated with this AppConnection.
   *
   * @var string[]
   */
  public $connectors;
  /**
   * Output only. Timestamp when the resource was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Optional. An arbitrary user-provided name for the AppConnection. Cannot
   * exceed 64 characters.
   *
   * @var string
   */
  public $displayName;
  protected $gatewayType = GoogleCloudBeyondcorpAppconnectionsV1AppConnectionGateway::class;
  protected $gatewayDataType = '';
  /**
   * Optional. Resource labels to represent user provided metadata.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Required. Unique resource name of the AppConnection. The name is ignored
   * when creating a AppConnection.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzi;
  /**
   * Output only. Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzs;
  /**
   * Output only. The current state of the AppConnection.
   *
   * @var string
   */
  public $state;
  /**
   * Required. The type of network connectivity used by the AppConnection.
   *
   * @var string
   */
  public $type;
  /**
   * Output only. A unique identifier for the instance generated by the system.
   *
   * @var string
   */
  public $uid;
  /**
   * Output only. Timestamp when the resource was last modified.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Required. Address of the remote application endpoint for the BeyondCorp
   * AppConnection.
   *
   * @param GoogleCloudBeyondcorpAppconnectionsV1AppConnectionApplicationEndpoint $applicationEndpoint
   */
  public function setApplicationEndpoint(GoogleCloudBeyondcorpAppconnectionsV1AppConnectionApplicationEndpoint $applicationEndpoint)
  {
    $this->applicationEndpoint = $applicationEndpoint;
  }
  /**
   * @return GoogleCloudBeyondcorpAppconnectionsV1AppConnectionApplicationEndpoint
   */
  public function getApplicationEndpoint()
  {
    return $this->applicationEndpoint;
  }
  /**
   * Optional. List of [google.cloud.beyondcorp.v1main.Connector.name] that are
   * authorised to be associated with this AppConnection.
   *
   * @param string[] $connectors
   */
  public function setConnectors($connectors)
  {
    $this->connectors = $connectors;
  }
  /**
   * @return string[]
   */
  public function getConnectors()
  {
    return $this->connectors;
  }
  /**
   * Output only. Timestamp when the resource was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. An arbitrary user-provided name for the AppConnection. Cannot
   * exceed 64 characters.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Optional. Gateway used by the AppConnection.
   *
   * @param GoogleCloudBeyondcorpAppconnectionsV1AppConnectionGateway $gateway
   */
  public function setGateway(GoogleCloudBeyondcorpAppconnectionsV1AppConnectionGateway $gateway)
  {
    $this->gateway = $gateway;
  }
  /**
   * @return GoogleCloudBeyondcorpAppconnectionsV1AppConnectionGateway
   */
  public function getGateway()
  {
    return $this->gateway;
  }
  /**
   * Optional. Resource labels to represent user provided metadata.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Required. Unique resource name of the AppConnection. The name is ignored
   * when creating a AppConnection.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. Reserved for future use.
   *
   * @param bool $satisfiesPzi
   */
  public function setSatisfiesPzi($satisfiesPzi)
  {
    $this->satisfiesPzi = $satisfiesPzi;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzi()
  {
    return $this->satisfiesPzi;
  }
  /**
   * Output only. Reserved for future use.
   *
   * @param bool $satisfiesPzs
   */
  public function setSatisfiesPzs($satisfiesPzs)
  {
    $this->satisfiesPzs = $satisfiesPzs;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzs()
  {
    return $this->satisfiesPzs;
  }
  /**
   * Output only. The current state of the AppConnection.
   *
   * Accepted values: STATE_UNSPECIFIED, CREATING, CREATED, UPDATING, DELETING,
   * DOWN
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Required. The type of network connectivity used by the AppConnection.
   *
   * Accepted values: TYPE_UNSPECIFIED, TCP_PROXY
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * Output only. A unique identifier for the instance generated by the system.
   *
   * @param string $uid
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * Output only. Timestamp when the resource was last modified.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudBeyondcorpAppconnectionsV1AppConnection::class, 'Google_Service_BeyondCorp_GoogleCloudBeyondcorpAppconnectionsV1AppConnection');
