<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class IntakeVlanAttachment extends \Google\Model
{
  /**
   * Identifier of the VLAN attachment.
   *
   * @var string
   */
  public $id;
  /**
   * Attachment pairing key.
   *
   * @var string
   */
  public $pairingKey;

  /**
   * Identifier of the VLAN attachment.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Attachment pairing key.
   *
   * @param string $pairingKey
   */
  public function setPairingKey($pairingKey)
  {
    $this->pairingKey = $pairingKey;
  }
  /**
   * @return string
   */
  public function getPairingKey()
  {
    return $this->pairingKey;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(IntakeVlanAttachment::class, 'Google_Service_Baremetalsolution_IntakeVlanAttachment');
