<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ArtifactRegistry;

class VulnerabilityScanningConfig extends \Google\Model
{
  /**
   * Not set. This will be treated as INHERITED for Docker repositories and
   * DISABLED for non-Docker repositories.
   */
  public const ENABLEMENT_CONFIG_ENABLEMENT_CONFIG_UNSPECIFIED = 'ENABLEMENT_CONFIG_UNSPECIFIED';
  /**
   * Scanning is Enabled, but dependent on API enablement.
   */
  public const ENABLEMENT_CONFIG_INHERITED = 'INHERITED';
  /**
   * No automatic vulnerability scanning will be performed for this repository.
   */
  public const ENABLEMENT_CONFIG_DISABLED = 'DISABLED';
  /**
   * Enablement state is unclear.
   */
  public const ENABLEMENT_STATE_ENABLEMENT_STATE_UNSPECIFIED = 'ENABLEMENT_STATE_UNSPECIFIED';
  /**
   * Repository does not support vulnerability scanning.
   */
  public const ENABLEMENT_STATE_SCANNING_UNSUPPORTED = 'SCANNING_UNSUPPORTED';
  /**
   * Vulnerability scanning is disabled for this repository.
   */
  public const ENABLEMENT_STATE_SCANNING_DISABLED = 'SCANNING_DISABLED';
  /**
   * Vulnerability scanning is active for this repository.
   */
  public const ENABLEMENT_STATE_SCANNING_ACTIVE = 'SCANNING_ACTIVE';
  /**
   * Optional. Config for whether this repository has vulnerability scanning
   * disabled.
   *
   * @var string
   */
  public $enablementConfig;
  /**
   * Output only. State of feature enablement, combining repository enablement
   * config and API enablement state.
   *
   * @var string
   */
  public $enablementState;
  /**
   * Output only. Reason for the repository state.
   *
   * @var string
   */
  public $enablementStateReason;
  /**
   * Output only. The last time this repository config was enabled.
   *
   * @var string
   */
  public $lastEnableTime;

  /**
   * Optional. Config for whether this repository has vulnerability scanning
   * disabled.
   *
   * Accepted values: ENABLEMENT_CONFIG_UNSPECIFIED, INHERITED, DISABLED
   *
   * @param self::ENABLEMENT_CONFIG_* $enablementConfig
   */
  public function setEnablementConfig($enablementConfig)
  {
    $this->enablementConfig = $enablementConfig;
  }
  /**
   * @return self::ENABLEMENT_CONFIG_*
   */
  public function getEnablementConfig()
  {
    return $this->enablementConfig;
  }
  /**
   * Output only. State of feature enablement, combining repository enablement
   * config and API enablement state.
   *
   * Accepted values: ENABLEMENT_STATE_UNSPECIFIED, SCANNING_UNSUPPORTED,
   * SCANNING_DISABLED, SCANNING_ACTIVE
   *
   * @param self::ENABLEMENT_STATE_* $enablementState
   */
  public function setEnablementState($enablementState)
  {
    $this->enablementState = $enablementState;
  }
  /**
   * @return self::ENABLEMENT_STATE_*
   */
  public function getEnablementState()
  {
    return $this->enablementState;
  }
  /**
   * Output only. Reason for the repository state.
   *
   * @param string $enablementStateReason
   */
  public function setEnablementStateReason($enablementStateReason)
  {
    $this->enablementStateReason = $enablementStateReason;
  }
  /**
   * @return string
   */
  public function getEnablementStateReason()
  {
    return $this->enablementStateReason;
  }
  /**
   * Output only. The last time this repository config was enabled.
   *
   * @param string $lastEnableTime
   */
  public function setLastEnableTime($lastEnableTime)
  {
    $this->lastEnableTime = $lastEnableTime;
  }
  /**
   * @return string
   */
  public function getLastEnableTime()
  {
    return $this->lastEnableTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityScanningConfig::class, 'Google_Service_ArtifactRegistry_VulnerabilityScanningConfig');
