<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Analytics;

class AccountTreeRequest extends \Google\Model
{
  /**
   * @var string
   */
  public $accountName;
  /**
   * Resource type for account ticket.
   *
   * @var string
   */
  public $kind;
  /**
   * @var string
   */
  public $profileName;
  /**
   * @var string
   */
  public $timezone;
  /**
   * @var string
   */
  public $webpropertyName;
  /**
   * @var string
   */
  public $websiteUrl;

  /**
   * @param string $accountName
   */
  public function setAccountName($accountName)
  {
    $this->accountName = $accountName;
  }
  /**
   * @return string
   */
  public function getAccountName()
  {
    return $this->accountName;
  }
  /**
   * Resource type for account ticket.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param string $profileName
   */
  public function setProfileName($profileName)
  {
    $this->profileName = $profileName;
  }
  /**
   * @return string
   */
  public function getProfileName()
  {
    return $this->profileName;
  }
  /**
   * @param string $timezone
   */
  public function setTimezone($timezone)
  {
    $this->timezone = $timezone;
  }
  /**
   * @return string
   */
  public function getTimezone()
  {
    return $this->timezone;
  }
  /**
   * @param string $webpropertyName
   */
  public function setWebpropertyName($webpropertyName)
  {
    $this->webpropertyName = $webpropertyName;
  }
  /**
   * @return string
   */
  public function getWebpropertyName()
  {
    return $this->webpropertyName;
  }
  /**
   * @param string $websiteUrl
   */
  public function setWebsiteUrl($websiteUrl)
  {
    $this->websiteUrl = $websiteUrl;
  }
  /**
   * @return string
   */
  public function getWebsiteUrl()
  {
    return $this->websiteUrl;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AccountTreeRequest::class, 'Google_Service_Analytics_AccountTreeRequest');
