<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityViewData extends \Google\Model
{
  protected $valueType = GoogleCloudAiplatformV1FeatureValue::class;
  protected $valueDataType = '';
  protected $valuesType = GoogleCloudAiplatformV1FeatureValueList::class;
  protected $valuesDataType = '';

  /**
   * Feature value if a single value is requested.
   *
   * @param GoogleCloudAiplatformV1FeatureValue $value
   */
  public function setValue(GoogleCloudAiplatformV1FeatureValue $value)
  {
    $this->value = $value;
  }
  /**
   * @return GoogleCloudAiplatformV1FeatureValue
   */
  public function getValue()
  {
    return $this->value;
  }
  /**
   * Feature values list if values, successive in time, are requested. If the
   * requested number of values is greater than the number of existing Feature
   * values, nonexistent values are omitted instead of being returned as empty.
   *
   * @param GoogleCloudAiplatformV1FeatureValueList $values
   */
  public function setValues(GoogleCloudAiplatformV1FeatureValueList $values)
  {
    $this->values = $values;
  }
  /**
   * @return GoogleCloudAiplatformV1FeatureValueList
   */
  public function getValues()
  {
    return $this->values;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityViewData::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityViewData');
