<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1DataLabelingJob extends \Google\Collection
{
  /**
   * The job state is unspecified.
   */
  public const STATE_JOB_STATE_UNSPECIFIED = 'JOB_STATE_UNSPECIFIED';
  /**
   * The job has been just created or resumed and processing has not yet begun.
   */
  public const STATE_JOB_STATE_QUEUED = 'JOB_STATE_QUEUED';
  /**
   * The service is preparing to run the job.
   */
  public const STATE_JOB_STATE_PENDING = 'JOB_STATE_PENDING';
  /**
   * The job is in progress.
   */
  public const STATE_JOB_STATE_RUNNING = 'JOB_STATE_RUNNING';
  /**
   * The job completed successfully.
   */
  public const STATE_JOB_STATE_SUCCEEDED = 'JOB_STATE_SUCCEEDED';
  /**
   * The job failed.
   */
  public const STATE_JOB_STATE_FAILED = 'JOB_STATE_FAILED';
  /**
   * The job is being cancelled. From this state the job may only go to either
   * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
   */
  public const STATE_JOB_STATE_CANCELLING = 'JOB_STATE_CANCELLING';
  /**
   * The job has been cancelled.
   */
  public const STATE_JOB_STATE_CANCELLED = 'JOB_STATE_CANCELLED';
  /**
   * The job has been stopped, and can be resumed.
   */
  public const STATE_JOB_STATE_PAUSED = 'JOB_STATE_PAUSED';
  /**
   * The job has expired.
   */
  public const STATE_JOB_STATE_EXPIRED = 'JOB_STATE_EXPIRED';
  /**
   * The job is being updated. Only jobs in the `RUNNING` state can be updated.
   * After updating, the job goes back to the `RUNNING` state.
   */
  public const STATE_JOB_STATE_UPDATING = 'JOB_STATE_UPDATING';
  /**
   * The job is partially succeeded, some results may be missing due to errors.
   */
  public const STATE_JOB_STATE_PARTIALLY_SUCCEEDED = 'JOB_STATE_PARTIALLY_SUCCEEDED';
  protected $collection_key = 'specialistPools';
  protected $activeLearningConfigType = GoogleCloudAiplatformV1ActiveLearningConfig::class;
  protected $activeLearningConfigDataType = '';
  /**
   * Labels to assign to annotations generated by this DataLabelingJob. Label
   * keys and values can be no longer than 64 characters (Unicode codepoints),
   * can only contain lowercase letters, numeric characters, underscores and
   * dashes. International characters are allowed. See https://goo.gl/xmQnxf for
   * more information and examples of labels. System reserved label keys are
   * prefixed with "aiplatform.googleapis.com/" and are immutable.
   *
   * @var string[]
   */
  public $annotationLabels;
  /**
   * Output only. Timestamp when this DataLabelingJob was created.
   *
   * @var string
   */
  public $createTime;
  protected $currentSpendType = GoogleTypeMoney::class;
  protected $currentSpendDataType = '';
  /**
   * Required. Dataset resource names. Right now we only support labeling from a
   * single Dataset. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   *
   * @var string[]
   */
  public $datasets;
  /**
   * Required. The user-defined name of the DataLabelingJob. The name can be up
   * to 128 characters long and can consist of any UTF-8 characters. Display
   * name of a DataLabelingJob.
   *
   * @var string
   */
  public $displayName;
  protected $encryptionSpecType = GoogleCloudAiplatformV1EncryptionSpec::class;
  protected $encryptionSpecDataType = '';
  protected $errorType = GoogleRpcStatus::class;
  protected $errorDataType = '';
  /**
   * Required. Input config parameters for the DataLabelingJob.
   *
   * @var array
   */
  public $inputs;
  /**
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * the config for a specific type of DataLabelingJob. The schema files that
   * can be used here are found in the https://storage.googleapis.com/google-
   * cloud-aiplatform bucket in the /schema/datalabelingjob/inputs/ folder.
   *
   * @var string
   */
  public $inputsSchemaUri;
  /**
   * Required. The Google Cloud Storage location of the instruction pdf. This
   * pdf is shared with labelers, and provides detailed description on how to
   * label DataItems in Datasets.
   *
   * @var string
   */
  public $instructionUri;
  /**
   * Required. Number of labelers to work on each DataItem.
   *
   * @var int
   */
  public $labelerCount;
  /**
   * Output only. Current labeling job progress percentage scaled in interval
   * [0, 100], indicating the percentage of DataItems that has been finished.
   *
   * @var int
   */
  public $labelingProgress;
  /**
   * The labels with user-defined metadata to organize your DataLabelingJobs.
   * Label keys and values can be no longer than 64 characters (Unicode
   * codepoints), can only contain lowercase letters, numeric characters,
   * underscores and dashes. International characters are allowed. See
   * https://goo.gl/xmQnxf for more information and examples of labels. System
   * reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
   * immutable. Following system labels exist for each DataLabelingJob: *
   * "aiplatform.googleapis.com/schema": output only, its value is the
   * inputs_schema's title.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Output only. Resource name of the DataLabelingJob.
   *
   * @var string
   */
  public $name;
  /**
   * The SpecialistPools' resource names associated with this job.
   *
   * @var string[]
   */
  public $specialistPools;
  /**
   * Output only. The detailed state of the job.
   *
   * @var string
   */
  public $state;
  /**
   * Output only. Timestamp when this DataLabelingJob was updated most recently.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Parameters that configure the active learning pipeline. Active learning
   * will label the data incrementally via several iterations. For every
   * iteration, it will select a batch of data based on the sampling strategy.
   *
   * @param GoogleCloudAiplatformV1ActiveLearningConfig $activeLearningConfig
   */
  public function setActiveLearningConfig(GoogleCloudAiplatformV1ActiveLearningConfig $activeLearningConfig)
  {
    $this->activeLearningConfig = $activeLearningConfig;
  }
  /**
   * @return GoogleCloudAiplatformV1ActiveLearningConfig
   */
  public function getActiveLearningConfig()
  {
    return $this->activeLearningConfig;
  }
  /**
   * Labels to assign to annotations generated by this DataLabelingJob. Label
   * keys and values can be no longer than 64 characters (Unicode codepoints),
   * can only contain lowercase letters, numeric characters, underscores and
   * dashes. International characters are allowed. See https://goo.gl/xmQnxf for
   * more information and examples of labels. System reserved label keys are
   * prefixed with "aiplatform.googleapis.com/" and are immutable.
   *
   * @param string[] $annotationLabels
   */
  public function setAnnotationLabels($annotationLabels)
  {
    $this->annotationLabels = $annotationLabels;
  }
  /**
   * @return string[]
   */
  public function getAnnotationLabels()
  {
    return $this->annotationLabels;
  }
  /**
   * Output only. Timestamp when this DataLabelingJob was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
   * incurred to date.
   *
   * @param GoogleTypeMoney $currentSpend
   */
  public function setCurrentSpend(GoogleTypeMoney $currentSpend)
  {
    $this->currentSpend = $currentSpend;
  }
  /**
   * @return GoogleTypeMoney
   */
  public function getCurrentSpend()
  {
    return $this->currentSpend;
  }
  /**
   * Required. Dataset resource names. Right now we only support labeling from a
   * single Dataset. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   *
   * @param string[] $datasets
   */
  public function setDatasets($datasets)
  {
    $this->datasets = $datasets;
  }
  /**
   * @return string[]
   */
  public function getDatasets()
  {
    return $this->datasets;
  }
  /**
   * Required. The user-defined name of the DataLabelingJob. The name can be up
   * to 128 characters long and can consist of any UTF-8 characters. Display
   * name of a DataLabelingJob.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Customer-managed encryption key spec for a DataLabelingJob. If set, this
   * DataLabelingJob will be secured by this key. Note: Annotations created in
   * the DataLabelingJob are associated with the EncryptionSpec of the Dataset
   * they are exported to.
   *
   * @param GoogleCloudAiplatformV1EncryptionSpec $encryptionSpec
   */
  public function setEncryptionSpec(GoogleCloudAiplatformV1EncryptionSpec $encryptionSpec)
  {
    $this->encryptionSpec = $encryptionSpec;
  }
  /**
   * @return GoogleCloudAiplatformV1EncryptionSpec
   */
  public function getEncryptionSpec()
  {
    return $this->encryptionSpec;
  }
  /**
   * Output only. DataLabelingJob errors. It is only populated when job's state
   * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
   *
   * @param GoogleRpcStatus $error
   */
  public function setError(GoogleRpcStatus $error)
  {
    $this->error = $error;
  }
  /**
   * @return GoogleRpcStatus
   */
  public function getError()
  {
    return $this->error;
  }
  /**
   * Required. Input config parameters for the DataLabelingJob.
   *
   * @param array $inputs
   */
  public function setInputs($inputs)
  {
    $this->inputs = $inputs;
  }
  /**
   * @return array
   */
  public function getInputs()
  {
    return $this->inputs;
  }
  /**
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * the config for a specific type of DataLabelingJob. The schema files that
   * can be used here are found in the https://storage.googleapis.com/google-
   * cloud-aiplatform bucket in the /schema/datalabelingjob/inputs/ folder.
   *
   * @param string $inputsSchemaUri
   */
  public function setInputsSchemaUri($inputsSchemaUri)
  {
    $this->inputsSchemaUri = $inputsSchemaUri;
  }
  /**
   * @return string
   */
  public function getInputsSchemaUri()
  {
    return $this->inputsSchemaUri;
  }
  /**
   * Required. The Google Cloud Storage location of the instruction pdf. This
   * pdf is shared with labelers, and provides detailed description on how to
   * label DataItems in Datasets.
   *
   * @param string $instructionUri
   */
  public function setInstructionUri($instructionUri)
  {
    $this->instructionUri = $instructionUri;
  }
  /**
   * @return string
   */
  public function getInstructionUri()
  {
    return $this->instructionUri;
  }
  /**
   * Required. Number of labelers to work on each DataItem.
   *
   * @param int $labelerCount
   */
  public function setLabelerCount($labelerCount)
  {
    $this->labelerCount = $labelerCount;
  }
  /**
   * @return int
   */
  public function getLabelerCount()
  {
    return $this->labelerCount;
  }
  /**
   * Output only. Current labeling job progress percentage scaled in interval
   * [0, 100], indicating the percentage of DataItems that has been finished.
   *
   * @param int $labelingProgress
   */
  public function setLabelingProgress($labelingProgress)
  {
    $this->labelingProgress = $labelingProgress;
  }
  /**
   * @return int
   */
  public function getLabelingProgress()
  {
    return $this->labelingProgress;
  }
  /**
   * The labels with user-defined metadata to organize your DataLabelingJobs.
   * Label keys and values can be no longer than 64 characters (Unicode
   * codepoints), can only contain lowercase letters, numeric characters,
   * underscores and dashes. International characters are allowed. See
   * https://goo.gl/xmQnxf for more information and examples of labels. System
   * reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
   * immutable. Following system labels exist for each DataLabelingJob: *
   * "aiplatform.googleapis.com/schema": output only, its value is the
   * inputs_schema's title.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Output only. Resource name of the DataLabelingJob.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The SpecialistPools' resource names associated with this job.
   *
   * @param string[] $specialistPools
   */
  public function setSpecialistPools($specialistPools)
  {
    $this->specialistPools = $specialistPools;
  }
  /**
   * @return string[]
   */
  public function getSpecialistPools()
  {
    return $this->specialistPools;
  }
  /**
   * Output only. The detailed state of the job.
   *
   * Accepted values: JOB_STATE_UNSPECIFIED, JOB_STATE_QUEUED,
   * JOB_STATE_PENDING, JOB_STATE_RUNNING, JOB_STATE_SUCCEEDED,
   * JOB_STATE_FAILED, JOB_STATE_CANCELLING, JOB_STATE_CANCELLED,
   * JOB_STATE_PAUSED, JOB_STATE_EXPIRED, JOB_STATE_UPDATING,
   * JOB_STATE_PARTIALLY_SUCCEEDED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Output only. Timestamp when this DataLabelingJob was updated most recently.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1DataLabelingJob::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1DataLabelingJob');
