<?php

	function generateIcsString(array $eventData): string {
    	// Make sure all required data is present
    	if (empty($eventData['title']) || empty($eventData['start_date']) || empty($eventData['end_date'])) {
        	throw new InvalidArgumentException('Missing required event data.');
    	}

    	// Define timezones
    	$localTimezone = new DateTimeZone('America/Santiago');
    	$utcTimezone = new DateTimeZone('UTC');

    	// Create DateTime objects and convert to UTC
    	$dtStart = (new DateTime($eventData['start_date'], $localTimezone))->setTimezone($utcTimezone)->format('Ymd\THis\Z');
    	$dtEnd = (new DateTime($eventData['end_date'], $localTimezone))->setTimezone($utcTimezone)->format('Ymd\THis\Z');
    	$dtStamp = (new DateTime('now', $utcTimezone))->format('Ymd\THis\Z');
    	$uid = md5(uniqid(mt_rand(), true) . $eventData['title']); // Generate a robust UID

	    // Build the ICS content string
    	$ics_content = "BEGIN:VCALENDAR\r\n";
    	$ics_content .= "VERSION:2.0\r\n";
    	$ics_content .= "PRODID:-//RedDePrevencion/Plataforma//NONSGML v1.0//ES\r\n";
    	$ics_content .= "BEGIN:VEVENT\r\n";
		$ics_content .= "METHOD:REQUEST\r\n";
    	$ics_content .= "UID:" . $uid . "\r\n";
    	$ics_content .= "DTSTAMP:" . $dtStamp . "\r\n";
    	$ics_content .= "DTSTART:" . $dtStart . "\r\n";
    	$ics_content .= "DTEND:" . $dtEnd . "\r\n";
    	$ics_content .= "SUMMARY:" . $eventData['title'] . "\r\n";
    	$ics_content .= "LOCATION:" . ($eventData['location'] ?? '') . "\r\n";
    	$ics_content .= "DESCRIPTION:" . ($eventData['description'] ?? '') . "\r\n";
		$ics_content .= "STATUS:CONFIRMED\r\n";
		$ics_content .= "SEQUENCE:0\r\n";
		$ics_content .= "TRANSP:OPAQUE\r\n";

    	// Add Organizer
    	if (!empty($eventData['organizer_email'])) {
        	$organizerName = $eventData['organizer_name'] ?? $eventData['organizer_email'];
        	$ics_content .= "ORGANIZER;CN={$organizerName}:mailto:{$eventData['organizer_email']}\r\n";
    	}

    	// Add Attendees
    	if (!empty($eventData['attendees'])) {
        	foreach ($eventData['attendees'] as $attendeeEmail) {
            	$ics_content .= "ATTENDEE;PARTSTAT=NEEDS-ACTION;RSVP=TRUE:mailto:{$attendeeEmail}\r\n";
        	}
    	}

    	$ics_content .= "END:VEVENT\r\n";
    	$ics_content .= "END:VCALENDAR\r\n";

    	return $ics_content;
	}

?>